<?php
//
// +----------------------------------------------------------------------+
// |zen-cart Open Source E-commerce                                       |
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 The zen-cart developers                           |
// |                                                                      |
// | http://www.zen-cart.com/index.php                                    |
// |                                                                      |
// | Portions Copyright (c) 2003 osCommerce                               |
// +----------------------------------------------------------------------+
// | This source file is subject to version 2.0 of the GPL license,       |
// | that is bundled with this package in the file LICENSE, and is        |
// | available through the world-wide-web at the following url:           |
// | http://www.zen-cart.com/license/2_0.txt.                             |
// | If you did not receive a copy of the zen-cart license and are unable |
// | to obtain it through the world-wide-web, please send a note to       |
// | license@zen-cart.com so we can mail you a copy immediately.          |
// +----------------------------------------------------------------------+
// $Id: category_list.php  2004-10-29 
//

class category_list {	
	var 
		$root_category_id = 0,
		$max_level = 0,
		$data = array(),
		$box_categories_array=array(); 
	
	function category_list() {
		global $languages_id, $db;
		$this->icount=0;
		$this->box_categories_array=array();
		$this->data = array();
		$categories_query = "select c.categories_id, cd.categories_name, c.parent_id
                       from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd
                       where c.categories_id = cd.categories_id
                       and cd.language_id = '" . (int)$_SESSION['languages_id'] . "'
                       order by c.parent_id, c.sort_order, cd.categories_name";
		$categories = $db->Execute($categories_query);
		while (!$categories->EOF) {		
			$this->data[$categories->fields['parent_id']][$categories->fields['categories_id']] = 
				array('name' => $categories->fields['categories_name'], 'count' => 0);
			$categories->MoveNext();
		}		
	}
  
	function build_branch($parent_id, $level = 0, $parent_link = ''){
		$box_categories_array = & $this->box_category_array;
		$icount = & $this->icount;
		if (!isset($this->data[$parent_id])){ 
			return;
		}
		//next id not used
		$box_categories_array[$icount]['next_id']=false;
		$box_categories_array[$icount]['is_product']=false;
		$box_categories_array[$icount]['level']=$level;
		foreach ($this->data[$parent_id] as $category_id => $category){ 
			if ($parent_id == 0){ 
				$box_categories_array[$icount]['top']='true';
			}else{
				$box_categories_array[$icount]['top']='false';
			}
			$category_link = 'cPath='. $parent_link.$category_id; 			
			$box_categories_array[$icount]['path'] = $category_link;
			$box_categories_array[$icount]['name'] = $category['name'];
			$box_categories_array[$icount]['count'] = zen_count_products_in_category($category_id) ;
			// this doesn't work :(
			if($category_id == $current_category_id){
				$box_categories_array[$icount]['current']=true;
			}else{
				$box_categories_array[$icount]['current']=false;
			}
			if (isset($this->data[$category_id])) { 
				$box_categories_array[$icount]['has_sub_cat'] = true; 
			} else {
				$box_categories_array[$icount]['has_sub_cat'] = false; 
			}
			$box_categories_array[$icount]['category_id'] = $category_id;
			$icount++;
			$this->build_products($category_id, $category_link,$level);	
			if (isset($this->data[$category_id]) && (($this->max_level == '0') || ($this->max_level > $level+1))) {
				$this->build_branch($category_id, $level+1, $category_link . '_');	
			}
		}		
		return  $box_categories_array;
	}
	
	function build_products($category_id, $category_link, $level){
		global $languages_id, $db;
		$box_categories_array = & $this->box_category_array;
		$icount = & $this->icount;
		$products_query = "SELECT ". TABLE_PRODUCTS .".products_id, products_name 
			FROM ". TABLE_PRODUCTS." 
			INNER JOIN ". TABLE_PRODUCTS_DESCRIPTION ." 
				ON ". TABLE_PRODUCTS .".products_id = ". TABLE_PRODUCTS_DESCRIPTION .".products_id 
			WHERE (((". TABLE_PRODUCTS_DESCRIPTION .".language_id)=". (int)$_SESSION['languages_id'] .") 
				AND ((". TABLE_PRODUCTS .".master_categories_id)=". $category_id ."))
			ORDER BY ". TABLE_PRODUCTS .".products_sort_order, ". TABLE_PRODUCTS_DESCRIPTION .".products_name";
		$products = $db->Execute($products_query);
		if (!$products->EOF){
			while (!$products->EOF){		
				$box_categories_array[$icount]['count'] = 0 ;
				$box_categories_array[$icount]['level']=$level;
				$box_categories_array[$icount]['top']='false';
				$box_categories_array[$icount]['is_product']=true;
				$box_categories_array[$icount]['has_sub_cat'] = false;
				$box_categories_array[$icount]['name']=$products->fields['products_name'];
				$box_categories_array[$icount]['path']= 'cPath=' . $category_link ."&products_id=".$products->fields['products_id'] ;
				$box_categories_array[$icount]['products_id']=$products->fields['products_id'] ;
				//this doesn't work :(
				if ($products->fields['products_id'] == $products_id){
					$box_categories_array[$icount]['current']=true;
				}else{
					$box_categories_array[$icount]['current']=false;
				}
				$products->MoveNext();
				$icount++;
			}  
		}
		return $result;
	}	
	
	function build_list() {
		return $this->build_branch($this->root_category_id);
	}		
}  
?>