<?php
/*
  Copyright (c) 2007-2008 Rod Gasson / VCSWEB
  Released under the GNU General Public License

  	$Id: austpost.php,v1.5.3  Jun 12th 2007
		    v1.5.3.1 Sep7 - fixed minimum dimension bug

	$Id: austpost.php,v2.0.1  Dec 7th 2007
		    Updated to include ECI and EPI
		    Implemented the use of vcsweb server (repository for fixed costs, eg, insurance rates, letter rates, etc

	$Id: austpost.php,v2.1.2  Feb 7th 2008
		    Updated to include prepaid express satchels
		    Added user defined toggle for cURL/FILE access
		    Added server side exclusions for non-insurable countries
		    added icons
		    added user configurable postage delays

	$Id: austpost.php,v2.1.3  Feb 9th 2008
		    Added missing icons 
		    Added font size change to estimated delivery days 
		    More code cleanups 

*/


class austpost {
var $code, $title, $description, $icon, $enabled;

// class constructor
function austpost() {
global $order, $db, $template ;

// disable only when entire cart is free shipping
if (zen_get_shipping_enabled($this->code)) {
 $this->enabled = ((MODULE_SHIPPING_AUSTPOST_STATUS == 'True') ? true : false);
 }


$this->code = 'austpost';
$this->title = MODULE_SHIPPING_AUSTPOST_TEXT_TITLE;
$this->description = MODULE_SHIPPING_AUSTPOST_TEXT_DESCRIPTION;
$this->sort_order = MODULE_SHIPPING_AUSTPOST_SORT_ORDER;
$this->icon = $template->get_template_dir('austpost.jpg', '', '','images/icons'). '/' . 'austpost.jpg';
$this->icon_rpp = $template->get_template_dir('austpost_rpp.jpg', '' , '','images/icons'). '/' . 'austpost_rpp.jpg';
$this->icon_air = $template->get_template_dir('austpost_air.jpg', '' , '','images/icons'). '/' . 'austpost_air.jpg';
$this->icon_airi = $template->get_template_dir('austpost_airi.jpg', '' , '','images/icons'). '/' . 'austpost_airi.jpg';
$this->icon_sea = $template->get_template_dir('austpost_sea.jpg', '' , '','images/icons'). '/' . 'austpost_sea.jpg';
$this->icon_seai = $template->get_template_dir('austpost_seai.jpg', '' , '','images/icons'). '/' . 'austpost_seai.jpg';
$this->icon_exp = $template->get_template_dir('austpost_exp.jpg', '', '','images/icons'). '/' . 'austpost_exp.jpg';
$this->icon_expi = $template->get_template_dir('austpost_epi.jpg', '', '','images/icons'). '/' . 'austpost_epi.jpg';
$this->icon_reg = $template->get_template_dir('austpost_regd.jpg', '', '','images/icons'). '/' . 'austpost_regd.jpg';
$this->icon_ins = $template->get_template_dir('austpost_ins.jpg', '', '','images/icons'). '/' . 'austpost_ins.jpg';
$this->icon_cod = $template->get_template_dir('austpost_cod.jpg', '', '','images/icons'). '/' . 'austpost_cod.jpg';
$this->icon_ecim = $template->get_template_dir('austpost_ecim.jpg', '', '','images/icons'). '/' . 'austpost_ecim.jpg';
$this->icon_ecid = $template->get_template_dir('austpost_ecid.jpg', '', '','images/icons'). '/' . 'austpost_ecid.jpg';
$this->icon_pps3 = $template->get_template_dir('austpost_pp3.jpg', '', '','images/icons'). '/' . 'austpost_pp3.jpg';
$this->icon_pps5 = $template->get_template_dir('austpost_pp5.jpg', '', '','images/icons'). '/' . 'austpost_pp5.jpg';
$this->icon_ppse3 = $template->get_template_dir('austpost_ppe3.jpg', '', '','images/icons'). '/' . 'austpost_ppe3.jpg';
$this->icon_ppse5 = $template->get_template_dir('austpost_ppe5.jpg', '', '','images/icons'). '/' . 'austpost_ppe5.jpg';
$this->icon_letsm = $template->get_template_dir('austpost_letsm.jpg', '', '','images/icons'). '/' . 'austpost_letsm.jpg';
$this->icon_env1 = $template->get_template_dir('austpost_env1.jpg', '', '','images/icons'). '/' . 'austpost_env1.jpg';
$this->icon_env2 = $template->get_template_dir('austpost_env2.jpg', '', '','images/icons'). '/' . 'austpost_env2.jpg';
$this->icon_env3 = $template->get_template_dir('austpost_env3.jpg', '', '','images/icons'). '/' . 'austpost_env3.jpg';
$this->icon_env4 = $template->get_template_dir('austpost_env4.jpg', '', '','images/icons'). '/' . 'austpost_env4.jpg';
// $this->icon_letlg = $template->get_template_dir('austpost_lrtlg.jpg', '', '','images/icons'). '/' . 'austpost_letlg.jpg';
$this->icon_letsmr = $template->get_template_dir('austpost_letsmr.jpg', '', '','images/icons'). '/' . 'austpost_letsmr.jpg';
$this->icon_del = $template->get_template_dir('austpost_del.jpg', '', '','images/icons'). '/' . 'austpost_del.jpg';
//$this->icon_leti = $template->get_template_dir('austpost_leti.jpg', '', '','images/icons'). '/' . 'austpost_leti.jpg';

$this->tax_class = MODULE_SHIPPING_AUSTPOST_TAX_CLASS;
$this->tax_basis = 'Shipping' ;


$this->allowed_methods = explode(", ", MODULE_SHIPPING_AUSTPOST_TYPES) ;
$this->types = array(	 'LET' =>  MODULE_SHIPPING_AUSTPOST_LET_TEXT_DESCRIPTION,
			 'rLET' => MODULE_SHIPPING_AUSTPOST_rLET_TEXT_DESCRIPTION,
			 'RPP' =>  MODULE_SHIPPING_AUSTPOST_RPP_TEXT_DESCRIPTION,
                         'REG' =>  MODULE_SHIPPING_AUSTPOST_REG_TEXT_DESCRIPTION,
                         'EXP' =>  MODULE_SHIPPING_AUSTPOST_EXP_TEXT_DESCRIPTION,
                         'EXPi' => MODULE_SHIPPING_AUSTPOST_EXPi_TEXT_DESCRIPTION,
                         'PPS3' => MODULE_SHIPPING_AUSTPOST_PPS3_TEXT_DESCRIPTION,
                         'PPS5' => MODULE_SHIPPING_AUSTPOST_PPS5_TEXT_DESCRIPTION,
                         'PPSE3' => MODULE_SHIPPING_AUSTPOST_PPSE3_TEXT_DESCRIPTION,
                         'PPSE5' => MODULE_SHIPPING_AUSTPOST_PPSE5_TEXT_DESCRIPTION,
                         'COD' =>  MODULE_SHIPPING_AUSTPOST_COD_TEXT_DESCRIPTION,
                         'AIR' =>  MODULE_SHIPPING_AUSTPOST_AIR_TEXT_DESCRIPTION,
                         'SEA' =>  MODULE_SHIPPING_AUSTPOST_SEA_TEXT_DESCRIPTION,
			 'RPPi' => MODULE_SHIPPING_AUSTPOST_RPPi_TEXT_DESCRIPTION,
                         'AIRi' => MODULE_SHIPPING_AUSTPOST_AIRi_TEXT_DESCRIPTION,
                         'SEAi' => MODULE_SHIPPING_AUSTPOST_SEAi_TEXT_DESCRIPTION,
                         'ECId' => MODULE_SHIPPING_AUSTPOST_ECId_TEXT_DESCRIPTION,
                         'ECIm' => MODULE_SHIPPING_AUSTPOST_ECIm_TEXT_DESCRIPTION
			 );

}


// class methods
function quote($method = '') {
global $db, $order,$cart, $shipping_weight, $shipping_num_boxes, $total_weight, $currencies ;

$bignumber="<span style=\"font-size: 20px ; vertical-align: top ; font-weight: bold ; \" > ";

//echo "METHOD $method <br>" ;

$frompcode = MODULE_SHIPPING_AUSTPOST_SPCODE; $dest_country=$order->delivery['country']['iso_code_2']; $topcode = str_replace(" ","",($order->delivery['postcode'])); $store = HTTP_SERVER ;

if (MODULE_SHIPPING_AUSTPOST_WEIGHT_FORMAT == "kgs") { $sweight = $shipping_weight * 1000 ; }
else { $sweight = $shipping_weight ; }

if ($sweight > 20000) {
    $methods[] = array( 'id' => "ERROR",  'title' => 'Parcel Exceeds 20kgs' ,'cost' => 'NA' ) ;
    $this->quotes['methods'] = $methods;   // set it
return $this->quotes; }  // exceeds AustPost maximum weight

$SERVER  = "http://austpost.vcsweb.com/" ;
$VERSION  = "2.1.3" ;

if(isset($_SESSION['fees'])) {

    $Fees = $_SESSION['fees'] ;
    $x = split('=',$Fees[1]) ; $lastcc = trim($x[1]) ;

    if ($lastcc != $dest_country) {
	unset($Fees) ;
	}
}

 if (!isset($Fees)) {    // Only contact server when necesary

//  echo "server" ;
    $Fees = GetAPdata($SERVER."fees.php?ver=$VERSION&dest=$dest_country&store=$store") ; $_SESSION['fees'] = $Fees ;
}

foreach($Fees as $key => $value) {
    $x = split('=', $value) ;
    $$x[0] = $x[1] ;
    }


// Uncomment the lines below to override values from the vcsweb.com server
//  Fees as of December 2007
// $costPrePaid3k=9.30 ;
// $costPrePaid500g=5.30 ;
// $costPrePaidExp3k=10.50 ;
// $costPrePaidExp500g=7.40 ;
// $costCOD=9.30 ;
// $costREGaus=2.70 ;
// $costREGints=10.85 ;
// $costREGintl=17.50 ;
// $costLETaus=50,1.00,1.45,2.45 ;
// $costLETint=1.95,3.85,5.80,11.60 ;
// $costINS=1.20,1.20,5.50,2.00 ;
//
// If reguired you can also adjust the server given fixed prices. eg:
// $costCOD=$costCOD+2.50 ;   // add $2.50 to the cost of COD charge.


$aus_rate = $currencies->get_value(AUD) ;
$xchange = $currencies->get_value($_SESSION['currency']) ;

$insurance = getinsurance($costINS) ;
$insurance_details1 = " $" .$insurance[0] . " " .MODULE_SHIPPING_AUSTPOST_TEXT_INSURANCE_AUST ;
$insurance_details2 = " $" .$insurance[1] . " " .MODULE_SHIPPING_AUSTPOST_TEXT_INSURANCE_INT;

// default dimensions //
$x = split(',', MODULE_SHIPPING_AUSTPOST_DIMS) ;
$var = array($x[0],$x[1],$x[2]) ; sort($var) ;
$slength = $var[2] ; $swidth =  $var[1] ; $sheight = $var[0] ;

// print_r($var) ;

// initialise maximums (probably not needed, but why chance it?)
$maxwidth = 0 ; $maxlength = 0 ;  $maxheight = 0 ; // $error = false;
$cube = 0 ; $counter = 0 ; $debug = 0 ;

// first we loop through cart extracting productIDs for special dimensions //

if(isset($_SESSION['customer_id'])) {    // user logged in - use the $orders class
if($debug == 1) {echo "via Cart"; }

for($x = 0 ; $x < count($order->products) ; $x++ ) {
    $t = $order->products[$x]['id'] ;
    $dim_query = "select products_length, products_height, products_width from " . TABLE_PRODUCTS . " where products_id='$t' and  products_length > '0' and products_weight > '0' and  products_width > '0' ";
    $dims = $db->Execute($dim_query);
    if ($dims->RecordCount() > 0) {  if($debug == 1) { echo "overide" ; }

    // re-orientate //
    $var = array($dims->fields['products_width'], $dims->fields['products_height'], $dims->fields['products_length']) ; sort($var) ;
    $dims->fields['products_length'] = $var[2] ; $dims->fields['products_width'] = $var[1] ;  $dims->fields['products_height'] = $var[0] ;

	$cube = $cube + ($dims->fields['products_width'] * $dims->fields['products_height'] * $dims->fields['products_length'] * $order->products[$x]['qty']) ;
	    if($debug == 1) { echo "cube =:".$dims->fields['products_width'] ."x" . $dims->fields['products_height'] . "x" .$dims->fields['products_length'] . "x" . $order->products[$x]['qty'] ;   }
	if ($dims->fields['products_width'] >  $maxwidth) { $maxwidth  = $dims->fields['products_width'] ; }
	if ($dims->fields['products_length'] > $maxlength) { $maxlength = $dims->fields['products_length'] ; }
	if ($dims->fields['products_height'] > $maxheight) { $maxheight = $dims->fields['products_height'] ; }
	}
    else { if($debug == 1) { echo "Default" ; } // echo "def" ;		// get track of default cubes for non assigned items //
	$defitems = $defitems + $order->products[$x]['qty']  ;
	    if($maxwidth == 0) {$maxwidth = $swidth ;}
	    if($maxheight == 0) {$maxheight = $sheight ;}
	    if($maxlength == 0) {$maxlength = $slength ;}

	}
  }
}
else 	// User not logged in - use Session cart.
{

$norder = $_SESSION['cart']->get_products();
if($debug == 1) {echo "via session"; }
// print_r($norder) ;
for($x = 0 ; $x < count($norder) ; $x++ ) {
    $t = $norder[$x]['id'] ;
   $dim_query = "select products_length, products_height, products_width from " . TABLE_PRODUCTS . " where products_id='$t' and  products_length > '0' and products_weight > '0' and  products_width > '0' ";
    $dims = $db->Execute($dim_query);
    if ($dims->RecordCount() > 0) { if($debug == 1) { echo "overide" ; }

    // re-orientate //
    $var = array($dims->fields['products_width'], $dims->fields['products_height'], $dims->fields['products_length']) ; sort($var) ;
    $dims->fields['products_length'] = $var[2] ; $dims->fields['products_width'] = $var[1] ;  $dims->fields['products_height'] = $var[0] ;

	$cube = $cube + ($dims->fields['products_width'] * $dims->fields['products_height'] * $dims->fields['products_length'] * $norder[$x]['quantity']) ;
	if ($dims->fields['products_width'] >  $maxwidth) { $maxwidth  = $dims->fields['products_width'] ; }
	if ($dims->fields['products_length'] > $maxlength) { $maxlength = $dims->fields['products_length'] ; }
	if ($dims->fields['products_height'] > $maxheight) { $maxheight = $dims->fields['products_height'] ; }

    }
    else {  if($debug == 1) { echo "default" ;} 	// get track of default cubes for non assigned items //
	$defitems = $defitems + $norder[$x]['quantity']  ;
	    if($maxwidth == 0) {$maxwidth = $swidth ;}
	    if($maxheight == 0) {$maxheight = $sheight ;}
	    if($maxlength == 0) {$maxlength = $slength ;}
    }
  }
}



//  summarise the two cubes (default x items, plus explicit defined - note we use the max lengths & widths
//  for this rather than the defaults because a small default still needs to be stacked by height
$cube = $cube + ($maxwidth * $sheight * $maxlength * $defitems)  ;
if($debug == 1) {  echo "C $cube - W $maxwidth - H $sheight - L $maxlength - I $defitems<br>"; }

if(($maxwidth > 100) || ($maxlength > 100))  { echo "Error: Dimensions exceed maximum allowed - Please contact store owner for delivery costs" ; exit ; }

//  calculate our height (assumes products are stacked one atop the other)
$x = round(($cube / ( $maxlength * $maxwidth)),2)  ;

if($x > 100 ) {  //  maximum allowed by aust Post (actually, 105, but lets not be pedantic)
    $maxlength = 100 ;   // so we set our length to maximum allowed
    $x = round(($cube / ( $maxlength * $maxwidth)),2)  ; // then recalculate new height

}

// now find the shortest 2 sides (for girth)
$var = array($x, $maxlength, $maxwidth) ;
sort($var) ;
if(($var[0] * 2) + ($var[1] * 2) > 140 ) {   if($debug == 1) { echo "Girth exceeded1: $shipping_num_boxes " ; print_r($var) ;}
$maxwidth = intval($var[1] / 2) ;  $shipping_num_boxes++ ; // chop it in half and send it two boxes. /
$x = $var[0] ;
}

/////////////// check for letter size ////
if( ($var[2] < 24) && ($var[1] < 13) && ($var[0] < 0.5) && ($sweight < 2500) ) {
    $lr = 1 ; $lrt =  zen_image($this->icon_env1,  " - Small letter ") ;
    }
    else {
	if( ($var[2] < 36) && ($var[1] < 26) && ($var[0] < 2) ) {
	    if($sweight < 125) { $lr = 2 ; $lrt =  zen_image($this->icon_env2,  " - Large letter (0-125gm)") ;
	    }
	    else {
		if($sweight < 250) { $lr = 3 ; $lrt = zen_image($this->icon_env3,  " - Large letter (125-250gm)") ;
		}
		else {
		    if($sweight < 500) { $lr = 4 ; $lrt =  zen_image($this->icon_env4, " - Large letter (251-500gm)") ;
		    }
		}
	     }
	  }
    	}


//  use our new parcel dimensions
$swidth = $maxwidth ; $sheight = $x ; $slength = $maxlength;

//  save it for display purposes on quote form (this way I don't need to hack another system file)
$_SESSION['swidth'] = $swidth ; $_SESSION['sheight'] = $sheight ;
$_SESSION['slength'] = $slength ; $_SESSION['boxes'] = $shipping_num_boxes ;

// convert cm to mm 'cos thats what AustPost wants //
$swidth = $maxwidth * 10 ; $sheight = $x * 10 ; $slength = $maxlength * 10 ;

/////  Initialise our arrays
$this->quotes = array('id' => $this->code, 'module' => $this->title);
$methods = array() ;

//////////////////////////////////////////////////////////////
if(isset($lr)) {           //  Letters

    if (($dest_country == "AU") && (in_array("Letters (Aust)", $this->allowed_methods))) {
	$letters_table = split("," , $costLETaus);
	$shipping_austpost_let_cost = $letters_table[$lr-1];

	    if (in_array("Registered (Aust)", $this->allowed_methods)) {
	    $days = 3 + MODULE_SHIPPING_AUSTPOST_DOFFSET ;
	    $cost = $letters_table[$lr-1] + MODULE_SHIPPING_AUSTPOST_REG_HANDLING + $costREGaus ;
	    $cost = adjust4tax($cost,$this->tax_class, $order) ;
		if (MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING !='Yes') {
		$handling_details = " " . $currencies->format(MODULE_SHIPPING_AUSTPOST_REG_HANDLING * $xchange) . " " . MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING;
		$austpost_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details .  " " .$currencies->format(($costREGaus * $xchange)) . " " . MODULE_SHIPPING_AUSTPOST_TEXT_REGISTERED . " ";
	         }
	    $shipping_austpost_method =  zen_image($this->icon_letsmr, $this->types['rLET']) . $lrt . $bignumber . $days . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_addons;
	    $methods[] = array( 'id' => "rLET", 'title' => $shipping_austpost_method, 'cost' => $cost) ;
	    }

	$days = 2 + MODULE_SHIPPING_AUSTPOST_DOFFSET ;
    } else
    {
    if(($dest_country != "AU") && (in_array("Letters (O/seas)", $this->allowed_methods))) {
	$letters_table = split("," , $costLETint);
	$shipping_austpost_let_cost = $letters_table[$lr-1];

	    if (in_array("Registered (O/seas)", $this->allowed_methods)) {
	    $days = 7 + MODULE_SHIPPING_AUSTPOST_DOFFSET ;

		if ($lr > 1) {
		    $cost = $letters_table[$lr-1] + MODULE_SHIPPING_AUSTPOST_REG_HANDLING + $costREGintl ;
		} else {
		    $cost = $letters_table[$lr-1] + MODULE_SHIPPING_AUSTPOST_REG_HANDLING + $costREGints ;
		}
		if (MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING !='Yes') {
		    if ($lr > 1) {
			$austpost_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details .  " " .$currencies->format(($costREGintl * $xchange)) . " " . MODULE_SHIPPING_AUSTPOST_TEXT_REGISTERED . " ";
		    } else {
			$austpost_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details .  " " .$currencies->format(($costREGints * $xchange)) . " " . MODULE_SHIPPING_AUSTPOST_TEXT_REGISTERED . " ";
		    }
		$handling_details = " " . $currencies->format(MODULE_SHIPPING_AUSTPOST_REG_HANDLING * $xchange) . " " . MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING;
		}   // end of addons
		$shipping_austpost_method = zen_image($this->icon_letsmr, $this->types['rLET']) . $lrt . $bignumber . $days . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_addons;
		$methods[] = array( 'id' => "rLET", 'title' => $shipping_austpost_method, 'cost' => $cost) ;
	    }  // end of Registered
	$days = 7 + MODULE_SHIPPING_AUSTPOST_DOFFSET ;

      }  // end of o/seas check
    }  //  end of o/seas letters

//  Aust letters
    if ($shipping_austpost_let_cost > 0) {
	if ((MODULE_SHIPPING_AUSTPOST_LET_HANDLING >0) && (MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING !='Yes')) {
	    $handling_details_let = " $" . MODULE_SHIPPING_AUSTPOST_LET_HANDLING . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING ;
	    $austpost_let_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details_let . " ";
	    }
	$days = $days + MODULE_SHIPPING_AUSTPOST_DOFFSET ;
    $shipping_austpost_let_method =  zen_image($this->icon_letsm, $this->types['LET']) . $lrt . $bignumber . $days . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_let_addons;
    $shipping_austpost_let_cost = $letters_table[$lr-1];
    $cost = $shipping_austpost_let_cost + MODULE_SHIPPING_AUSTPOST_LET_HANDLING ;
    $cost = adjust4tax($cost,$this->tax_class, $order) ;
    $methods[] = array( 'id' => "LET", 'title' => $shipping_austpost_let_method, 'cost' => $cost) ;
    }	// we had a letter cost

}   // no letters

if((!isset($lr)) || (MODULE_SHIPPING_AUSTPOST_HIDE_PARCEL != "Yes") || ($shipping_austpost_let_cost == 0))  { // do parcel lookups up not letter, or if letter but not hidden

//////////////////////
// get girth
$var = array($swidth, $slength, $sheight) ;  sort($var) ; $girth = ($var[0] * 2) + ( $var[1] * 2) ;
////////////////////////

if ($dest_country == "AU") {    // only AU
// Prepaid stachels
    if ((in_array("500gm Satchels", $this->allowed_methods)) && ( $sweight < 500 ) && ( $girth < 430 ) && ( $var[2] < 320 )) {

	if (MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING !='Yes') { $handling_details = " " . $currencies->format(MODULE_SHIPPING_AUSTPOST_PPS_HANDLING * $xchange) . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING ;
	$austpost_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details . " ";
	}

	$days = 4 + MODULE_SHIPPING_AUSTPOST_DOFFSET ;
	$shipping_austpost_method = zen_image($this->icon_pps5, $this->types['PPS5']) . $bignumber . $days . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_addons;
	$cost = $costPrePaid500g + MODULE_SHIPPING_AUSTPOST_PPS_HANDLING ;
	$cost = adjust4tax($cost,$this->tax_class, $order) ;
	$methods[] = array( 'id' => "PPS5", 'title' => $shipping_austpost_method, 'cost' => $cost) ;
}

else {

    if ((in_array("3kg Satchels", $this->allowed_methods))  && ( $sweight < 3000 ) && ( $girth < 600 )  && ( $var[2] < 370 )) {

	if (MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING !='Yes') { $handling_details = " " . $currencies->format(MODULE_SHIPPING_AUSTPOST_PPS_HANDLING * $xchange) . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING ;
	$austpost_addons =  MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details . " ";
	}

	$days = 4 + MODULE_SHIPPING_AUSTPOST_DOFFSET ;
	$shipping_austpost_method =  zen_image($this->icon_pps3, $this->types['PPS3']) . $bignumber . $days . "</span>" . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_addons;
	$cost = $costPrePaid3k + MODULE_SHIPPING_AUSTPOST_PPS_HANDLING ;
	$cost = adjust4tax($cost,$this->tax_class, $order) ;
	$methods[] = array( 'id' => "PPS3", 'title' => $shipping_austpost_method, 'cost' => $cost) ;
	}
    }

////
    if ((in_array("500gm Express Satchels", $this->allowed_methods)) && ( $sweight < 500 ) && ( $girth < 430 ) && ( $var[2] < 320 )) {

	if (MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING !='Yes') { $handling_details = " " . $currencies->format(MODULE_SHIPPING_AUSTPOST_PPSE_HANDLING * $xchange) . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING ;
	$austpost_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details . " ";
	}

	$days = 1 + MODULE_SHIPPING_AUSTPOST_DOFFSET ;
	$shipping_austpost_method =  zen_image($this->icon_ppse5, $this->types['PPSE5']) . $bignumber . $days . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_addons;
	$cost = $costPrePaidExp500g + MODULE_SHIPPING_AUSTPOST_PPSE_HANDLING ;
	$cost = adjust4tax($cost,$this->tax_class, $order) ;
	$methods[] = array( 'id' => "PPSE5", 'title' => $shipping_austpost_method, 'cost' => $cost) ;
}

else {

// echo "$sweight $girth  $var[2]" ;

    if ((in_array("3kg Express Satchels", $this->allowed_methods))  && ( $sweight < 3000 ) && ( $girth < 600 )  && ( $var[2] < 370 )) {

	if (MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING !='Yes') { $handling_details = " " . $currencies->format(MODULE_SHIPPING_AUSTPOST_PPSE_HANDLING * $xchange) . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING ;
	$austpost_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details . " ";
	}

	$days = 1 + MODULE_SHIPPING_AUSTPOST_DOFFSET ;
	$shipping_austpost_method =  zen_image($this->icon_ppse3, $this->types['PPSE3']) . $bignumber . $days . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_addons;
	$cost = $costPrePaidExp3k + MODULE_SHIPPING_AUSTPOST_PPSE_HANDLING ;
	$cost = adjust4tax($cost,$this->tax_class, $order) ;
	$methods[] = array( 'id' => "PPSE3", 'title' => $shipping_austpost_method, 'cost' => $cost) ;
	}
    }
////

}
////////////////////////////

///  too large for letter, but may be too small for drc server (minimum = 50x50x30)
/// Satchels have no min size, so we did them first

//print_r($var) ;  // meet minimum requirements
if ($var[0] < 50)  {$var[0] = 50 ; }
if ($var[1] < 50)  {$var[1] = 50 ; }
if ($var[2] < 50)  {$var[2] = 50 ; }
/////////////////////////

// create server query string
$SERVER = $SERVER."ratecalc.asp?Pickup_Postcode=$frompcode&Destination_Postcode=$topcode&Country=$dest_country&Weight=$sweight&Height=$var[0]&Width=$var[1]&Length=$var[2]&Quantity=$shipping_num_boxes&Service_Type=";

if ($dest_country == "AU") {
// Regular Parcel
	$myfile = GetAPdata($SERVER."STANDARD") ;
        foreach($myfile as $vals)
        { $bits = split("=", $vals); $$bits[0] = $bits[1]; }

	$days = $days + MODULE_SHIPPING_AUSTPOST_DOFFSET ;
//	$days = $bignumber. $days ;
      if ($charge > 0) {  $charge = $charge/$aus_rate ;

	if (MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING !='Yes') {
	    if (MODULE_SHIPPING_AUSTPOST_RPP_HANDLING >0) { $handling_details_rpp = " " . $currencies->format(MODULE_SHIPPING_AUSTPOST_RPP_HANDLING * $xchange) . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING; }
	    if (MODULE_SHIPPING_AUSTPOST_INS_HANDLING >0) { $handling_details_rppi =  " " .$currencies->format((MODULE_SHIPPING_AUSTPOST_RPP_HANDLING + MODULE_SHIPPING_AUSTPOST_INS_HANDLING) * $xchange) . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING; }
	    if (MODULE_SHIPPING_AUSTPOST_REG_HANDLING >0) {$handling_details_reg =  " " .$currencies->format(MODULE_SHIPPING_AUSTPOST_REG_HANDLING * $xchange) . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING; }
	    if (MODULE_SHIPPING_AUSTPOST_COD_HANDLING >0) { $handling_details_cod =  " " .$currencies->format(MODULE_SHIPPING_AUSTPOST_COD_HANDLING * $xchange) . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING;}

	    $austpost_rpp_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details_rpp  . " " ;
	    $austpost_reg_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details_reg  .  " " .$currencies->format(($costREGaus * $xchange)) . " " . MODULE_SHIPPING_AUSTPOST_TEXT_REGISTERED . " ";
	    $austpost_rppi_addons =  MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details_rppi .  " " .$currencies->format(($insurance[0] * $xchange)) . " " . MODULE_SHIPPING_AUSTPOST_TEXT_INSURANCE . " ";
	    $austpost_cod_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details_cod  .  " " .$currencies->format(($costCOD * $xchange)) . " " . MODULE_SHIPPING_AUSTPOST_TEXT_COD . " ";
	}

	$shipping_austpost_rpp_method =   zen_image($this->icon_rpp, $this->types['RPP'] ) . $bignumber . $days . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_rpp_addons;
	$shipping_austpost_rppi_method =  zen_image($this->icon_ins, $this->types['RPPi']) . $bignumber . ($days + 1) . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_rppi_addons;
	$shipping_austpost_reg_method =   zen_image($this->icon_reg, $this->types['REG'] ) . $bignumber . ($days + 1) . "</span> " . zen_image($this->icon_del,  MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_reg_addons;
	$shipping_austpost_cod_method =   zen_image($this->icon_cod, $this->types['COD'] ) . $bignumber . ($days + 2) . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_cod_addons;

	$shipping_austpost_rpp_cost = $charge;
	$shipping_austpost_rppi_cost = $charge + $insurance[0] ;
	$shipping_austpost_reg_cost = $charge + $costREGaus ;
	$shipping_austpost_cod_cost = $charge + $costCOD ;

}

// Express
	$myfile = GetAPdata($SERVER."EXPRESS") ;
        foreach($myfile as $vals)
        { $bits = split("=", $vals); $$bits[0] = $bits[1]; }

	$days = $days + MODULE_SHIPPING_AUSTPOST_DOFFSET ;

    	if ($charge > 0) {  $charge = $charge/$aus_rate ;

	    if ((MODULE_SHIPPING_AUSTPOST_EXP_HANDLING >0) && (MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING !='Yes')) {
		$handling_details_exp = " " . $currencies->format(MODULE_SHIPPING_AUSTPOST_EXP_HANDLING * $xchange) . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING ;
		$austpost_exp_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details_exp . " ";
	    }

	$shipping_austpost_exp_method = zen_image($this->icon_exp, $this->types['EXP']) . $bignumber . $days . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_exp_addons;
	$shipping_austpost_exp_cost = $charge;

}  // end of valid charge  - Express (au)

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
///  insert data into our array

if ((in_array("Regular Parcel", $this->allowed_methods)) && ( $shipping_austpost_rpp_cost > 0)) {
	// Rates returned include GST - so if we are in a GST enviroment
	// we reduce our total shipping cost by tax amount so zencart can correctly re-add it
	$cost = $shipping_austpost_rpp_cost + MODULE_SHIPPING_AUSTPOST_RPP_HANDLING ;
	$cost = adjust4tax($cost,$this->tax_class, $order) ;
	$methods[] = array( 'id' => "RPP", 'title' =>  $shipping_austpost_rpp_method, 'cost' => $cost) ;
}

if ((in_array("Registered (Aust)", $this->allowed_methods)) && (  $shipping_austpost_reg_cost > 0)) {
	$cost = $shipping_austpost_reg_cost + MODULE_SHIPPING_AUSTPOST_REG_HANDLING + MODULE_SHIPPING_AUSTPOST_REGISTERED ;
	$cost = adjust4tax($cost,$this->tax_class, $order) ;
	$methods[] = array( 'id' => "REG",  'title' => $shipping_austpost_reg_method, 'cost' => $cost ) ;
	}

if (((in_array("Insured Parcel (Aust)", $this->allowed_methods)) && ($insurance[0] > 0 ))  && ( $shipping_austpost_rppi_cost > 0)) {
	$cost = $shipping_austpost_rppi_cost + MODULE_SHIPPING_AUSTPOST_RPP_HANDLING + MODULE_SHIPPING_AUSTPOST_INS_HANDLING ;
	$cost = adjust4tax($cost,$this->tax_class, $order) ;
	$methods[] = array( 'id' => "RPPi", 'title' => $shipping_austpost_rppi_method, 'cost' => $cost) ;
	}

if ((in_array("Express (Aust)", $this->allowed_methods))  && (  $shipping_austpost_exp_cost > 0)){
	$cost = $shipping_austpost_exp_cost + MODULE_SHIPPING_AUSTPOST_EXP_HANDLING ;
	$cost = adjust4tax($cost,$this->tax_class, $order) ;
	$methods[] = array( 'id' => "EXP", 'title' => $shipping_austpost_exp_method,'cost' => $cost) ;
	}

if ((in_array("Cash on Delivery", $this->allowed_methods)) && (  $shipping_austpost_cod_cost  > 0)) {
	$cost = $shipping_austpost_cod_cost + MODULE_SHIPPING_AUSTPOST_COD_HANDLING ;
	$cost = adjust4tax($cost,$this->tax_class, $order) ;
	$methods[] = array('id' => "COD", 'title' => $shipping_austpost_cod_method, 'cost' => $cost ) ;
	}

}    //   Not AU
    else
{

// Air
    if (in_array("AIR", $this->allowed_methods)) {

	$myfile = GetAPdata($SERVER."Air") ;
        foreach($myfile as $vals)
        { $bits = split("=", $vals); $$bits[0] = $bits[1];}

	$days = $days + MODULE_SHIPPING_AUSTPOST_DOFFSET ;

        if ($charge > 0) {  $charge = $charge/$aus_rate ;

	    if (MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING !='Yes') { $handling_details_air = " " . $currencies->format(MODULE_SHIPPING_AUSTPOST_INT_HANDLING * $xchange) . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING ;
		if (MODULE_SHIPPING_AUSTPOST_INS_HANDLING >0) { $handling_details_airi = " " . $currencies->format((MODULE_SHIPPING_AUSTPOST_INT_HANDLING + MODULE_SHIPPING_AUSTPOST_INS_HANDLING) * $xchange) . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING;
		}
	    $austpost_air_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details_air . " ";
	    $austpost_airi_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details_airi . " " . $currencies->format(($insurance[1] * $xchange)) . " " . MODULE_SHIPPING_AUSTPOST_TEXT_INSURANCE . " ";
	    }

	$shipping_austpost_air_method =  zen_image($this->icon_air,$this->types['AIR']) . $bignumber . $days . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_air_addons;
	$shipping_austpost_air_cost = $charge ;
	$shipping_austpost_airi_cost = $charge + $insurance[1] ;
	$shipping_austpost_airi_method =  zen_image($this->icon_airi, $this->types['AIRi']) . $bignumber . $days . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_airi_addons;

	$methods[] = array( 'id' => "AIR",  'title' => $shipping_austpost_air_method,'cost' => ($shipping_austpost_air_cost + MODULE_SHIPPING_AUSTPOST_INT_HANDLING) ) ;

	if ((in_array("Insured AIR", $this->allowed_methods)) && ($insurance[1] > 0 )) {
	    $methods[] = array( 'id' => "AIRi",  'title' => $shipping_austpost_airi_method,'cost' => ($shipping_austpost_airi_cost + MODULE_SHIPPING_AUSTPOST_INT_HANDLING + MODULE_SHIPPING_AUSTPOST_INS_HANDLING ) );
	}
    }
}

// Sea
    if (in_array("SEA", $this->allowed_methods)) {
	$myfile = GetAPdata($SERVER."Sea") ;
        foreach($myfile as $vals)
        { $bits = split("=", $vals); $$bits[0] = $bits[1]; }

	$days = $days + MODULE_SHIPPING_AUSTPOST_DOFFSET ;

      if ($charge > 0) { $charge = $charge/$aus_rate ;

	if (MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING !='Yes') {
	    $handling_details = " " . $currencies->format(MODULE_SHIPPING_AUSTPOST_INT_HANDLING * $xchange) . " " . MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING;
	    $austpost_addons =  MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details . " ";
	}

	$shipping_austpost_method = zen_image($this->icon_sea,  $this->types['SEA']) . $bignumber . $days . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_addons;
	$methods[] = array( 'id' => "SEA",  'title' => $shipping_austpost_method,'cost' => ($charge + MODULE_SHIPPING_AUSTPOST_INT_HANDLING) ) ;
    }
 }

// Insured Sea
    if (in_array("Insured SEA", $this->allowed_methods)) {
	$myfile = GetAPdata($SERVER."Sea") ;
        foreach($myfile as $vals)
        { $bits = split("=", $vals); $$bits[0] = $bits[1]; }

	$days = $days + MODULE_SHIPPING_AUSTPOST_DOFFSET ;

	if ($charge > 0) { $charge = $charge/$aus_rate ;

	    if (MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING !='Yes') {
		$handling_details = " " . $currencies->format((MODULE_SHIPPING_AUSTPOST_INT_HANDLING + MODULE_SHIPPING_AUSTPOST_INS_HANDLING) * $xchange ) . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING;
		$austpost_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details . " " . $currencies->format($insurance[1] * $xchange) . " " . MODULE_SHIPPING_AUSTPOST_TEXT_INSURANCE . " " ;
	    }
	$shipping_austpost_method =  zen_image($this->icon_seai,  $this->types['SEAi']) . $bignumber . $days . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_addons;
	$charge = $charge + $insurance[1];

	    if ($insurance[1] > 0 ) {
		$methods[] = array( 'id' => "SEAi",  'title' => $shipping_austpost_method,'cost' => ($charge + MODULE_SHIPPING_AUSTPOST_INT_HANDLING + MODULE_SHIPPING_AUSTPOST_INS_HANDLING ) );
	    }
	}
    }


// International Express  (EPI)
    if (in_array("Express (O/seas)", $this->allowed_methods)) {
    $myfile = GetAPdata($SERVER."EPI") ;
        foreach($myfile as $vals) { $bits = split("=", $vals); $$bits[0] = $bits[1]; }

	$days = $days + MODULE_SHIPPING_AUSTPOST_DOFFSET ;

	if ($charge > 0) {  $charge = $charge/$aus_rate ;

	if ((MODULE_SHIPPING_AUSTPOST_EXP_HANDLING >0) && (MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING !='Yes')) { $handling_details = " " . $currencies->format(MODULE_SHIPPING_AUSTPOST_EXP_HANDLING * $xchange) . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING ;
	    $austpost_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details . " ";
	}

    $shipping_austpost_method = zen_image($this->icon_expi,  $this->types['EXPi']) . $bignumber . $days . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_addons;
    $methods[] = array( 'id' => "EXPi",  'title' => $shipping_austpost_method,'cost' => ($charge + MODULE_SHIPPING_AUSTPOST_EXP_HANDLING) ) ;}
    }


// ECI - Merchandise
    if (in_array("ECI Merchandise", $this->allowed_methods)) {

    $myfile = GetAPdata($SERVER."ECI_M") ;
        foreach($myfile as $vals)
        { $bits = split("=", $vals); $$bits[0] = $bits[1]; }

	$days = $days + MODULE_SHIPPING_AUSTPOST_DOFFSET ;

    	if ($charge > 0) {  $charge = $charge/$aus_rate ;

	if ((MODULE_SHIPPING_AUSTPOST_ECIM_HANDLING >0) && (MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING !='Yes')) { $handling_details = " " . $currencies->format(MODULE_SHIPPING_AUSTPOST_ECIM_HANDLING * $xchange) . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING ;
	    $austpost_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details . " ";
	}

    $shipping_austpost_method =  zen_image($this->icon_ecim,  $this->types['ECIm']) . $bignumber . $days . "</span> " . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_addons;
    $methods[] = array( 'id' => "ECIm",  'title' => $shipping_austpost_method,'cost' => ($charge + MODULE_SHIPPING_AUSTPOST_ECIM_HANDLING) ) ;}
    }


// ECI - Documents
    if (in_array("ECI Documents", $this->allowed_methods)) {
    $myfile = GetAPdata($SERVER."ECI_D") ;
        foreach($myfile as $vals)
        { $bits = split("=", $vals); $$bits[0] = $bits[1]; }

	$days = $days + MODULE_SHIPPING_AUSTPOST_DOFFSET ;

    	if ($charge > 0) {  $charge = $charge/$aus_rate ;

	if ((MODULE_SHIPPING_AUSTPOST_ECID_HANDLING >0) && (MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING !='Yes')) { $handling_details = " " . $currencies->format(MODULE_SHIPPING_AUSTPOST_ECID_HANDLING * $xchange) . " " .MODULE_SHIPPING_AUSTPOST_TEXT_HANDLING ;
	    $austpost_addons = MODULE_SHIPPING_AUSTPOST_TEXT_INCLUDE . $handling_details . " ";
	}

    $shipping_austpost_method =  zen_image($this->icon_ecid, $this->types['ECId']) . $bignumber . $days . "</span>" . zen_image($this->icon_del, MODULE_SHIPPING_AUSTPOST_TEXT_SHIPPINGDAYS) . $austpost_addons;
    $methods[] = array( 'id' => "ECId",  'title' => $shipping_austpost_method,'cost' => ($charge + MODULE_SHIPPING_AUSTPOST_ECID_HANDLING) ) ;
    }

    }

/////////////////////////////////

  } // Letter found - parcels hidden

}        /// end quotes


//  check to ensure we have at least one valid quote - produce error message if not.
if  (sizeof($methods) == 0 ) {
    $methods[] = array( 'id' => "NA",  'title' => MODULE_SHIPPING_AUSTPOST_TEXT_ERROR ,'cost' => 'NA' ) ;
    $this->quotes['methods'] = $methods;   // set it
}

else {

// Sort by cost //
    $sarray[] = array()  ; $resultarr = array() ;

        foreach($methods as $key => $value) {
		$sarray[ $key ] = $value['cost'] ;
    	}

        asort( $sarray ) ;

        foreach($sarray as $key => $value) {
		$resultarr[ $key ] = $methods[ $key ] ;
	}

// $this->quotes['methods'] = $methods;   // set it
	$this->quotes['methods'] = array_values($resultarr) ;   // set it
}

////////////////////////////////////////////////////////////
// if 'method' is set, we are going to checkout, only a single quote expected

if ($method) {

    foreach($methods as $temp) {
     $search = array_search("$method", $temp) ;
     if (strlen($search) > 0 && $search >= 0) {
	break ;
	}
      } ;

$this->quotes = array('id' => $this->code, 'module' => $this->title,
		     'methods' => array( array(
		        'id' => $method,
			'title' => $temp['title'],
			'cost' => $temp['cost'] )));
}

if ($this->tax_class >  0) { $this->quotes['tax'] = zen_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']); }
if (zen_not_null($this->icon)) $this->quotes['icon'] = zen_image($this->icon, $this->title);

return $this->quotes;
}


////////////////////////////////////////////////////////////////
function check() {
global $db;
if (!isset($this->_check)) {
$check_query = $db->Execute("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_AUSTPOST_STATUS'");
$this->_check = $check_query->RecordCount();
}
return $this->_check;
}
////////////////////////////////////////////////////////////////////////////
function install() {
global $db;
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Enable Australia post module by <a href =\"http://vcsweb.com\"/><img src=\"http://vcsweb.com/images/vcsweb_logo_zencart_mod.gif\" alt=\"http://vcsweb.com\"></a><br />', 'MODULE_SHIPPING_AUSTPOST_STATUS', 'True', 'Enable this Module', '6', '1', 'zen_cfg_select_option(array(\'True\', \'False\'), ', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Dispatch Postcode', 'MODULE_SHIPPING_AUSTPOST_SPCODE', '5161', 'Dispatch Postcode?', '6', '2', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (	configuration_title,
							configuration_key,
							configuration_value,
							configuration_description,
							configuration_group_id,
							sort_order,
							set_function,
							date_added)

					values ( 	'Shipping Methods: <br />',
							'MODULE_SHIPPING_AUSTPOST_TYPES',
							'Letters (Aust), Letters (O/seas), Regular Parcel, Insured Parcel (Aust), Registered (Aust), Registered (O/seas), Express (Aust), Express (O/seas), Cash on Delivery, AIR, Insured AIR, , Insured SEA, , ECI Merchandise, , 500gm Satchels, 3kg Satchels, , , ,',
							'Select the services to be offered.',
							'6',
							'3',
							'zen_cfg_select_multioption(array(\'Letters (Aust)\',\'Letters (O/seas)\',\'Regular Parcel\',\'Insured Parcel (Aust)\',\'Registered (Aust)\',\'Registered (O/seas)\',\'Express (Aust)\',\'Express (O/seas)\',\'Cash on Delivery\',\'AIR\',\'Insured AIR\',\'SEA\',\'Insured SEA\',\'ECI Documents\',\'ECI Merchandise\',\'500gm Satchels\',\'3kg Satchels\',\'500gm Express Satchels\',\'3kg Express Satchels\'), ',
							now() )");

$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Handling Fee - regular parcel', 'MODULE_SHIPPING_AUSTPOST_RPP_HANDLING', '5.00', 'Handling Fee Regular parcel  (keep in mind that handling fees need to include packaging material)', '6', '14', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Handling Fee - Registered post', 'MODULE_SHIPPING_AUSTPOST_REG_HANDLING', '7.00', 'Handling Fee for Registered Parcels', '6', '15', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Handling Fee - Express post', 'MODULE_SHIPPING_AUSTPOST_EXP_HANDLING', '10.00', 'Handling Fee Express parcels', '6', '16', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Handling Fee - Overseas post', 'MODULE_SHIPPING_AUSTPOST_INT_HANDLING', '8.00', 'Handling Fee for overseas parcels', '6', '17', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Handling Fee - COD', 'MODULE_SHIPPING_AUSTPOST_COD_HANDLING', '12.00', 'Handling Fee for COD deliveries', '6', '18', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Handling Fee - Letters', 'MODULE_SHIPPING_AUSTPOST_LET_HANDLING', '2.00', 'Handling Fee for letter sized parcels.', '6', '20', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Handling Fee - Prepaid Satchels', 'MODULE_SHIPPING_AUSTPOST_PPS_HANDLING', '4.00', 'Handling Fee for Prepaid Satchels.', '6', '21', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Handling Fee - Prepaid Express Satchels', 'MODULE_SHIPPING_AUSTPOST_PPSE_HANDLING', '5.00', 'Handling Fee for Prepaid Express Satchels.', '6', '21', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Handling Fee - ECI Documents', 'MODULE_SHIPPING_AUSTPOST_ECID_HANDLING', '10.00', 'Handling Fee - ECI Documents.', '6', '22', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Handling Fee - ECI Merchandise', 'MODULE_SHIPPING_AUSTPOST_ECIM_HANDLING', '10.00', 'Handling Fee - ECI Merchandise.', '6', '23', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Handling Fee - Insured parcels', 'MODULE_SHIPPING_AUSTPOST_INS_HANDLING', '2.00', 'Handling Fee for Insured deliveries - This is <strong>in addition</strong> to other handling fees.', '6', '24', now())");

$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Hide Handling Fees', 'MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING', 'No', 'The handling fees are still in the total shipping cost but the Handling Fee is not itemised on the invoice.', '6', '25', 'zen_cfg_select_option(array(\'Yes\', \'No\'), ', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Default Parcel Dimensions', 'MODULE_SHIPPING_AUSTPOST_DIMS', '29,25,2.5', 'Default Parcel dimensions (in cm). Three comma seperated values (eg 29,24,2.5 = 29cm x 24cm x 2.5cm). These are used if the dimensions of individual products are not set', '6', '26', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Parcel Weight format', 'MODULE_SHIPPING_AUSTPOST_WEIGHT_FORMAT', 'gms', 'Are your store items weighted by grams or Kilos (required so that we can pass the correct weight to the AustPost Server).', '6', '28', 'zen_cfg_select_option(array(\'gms\', \'kgs\'), ', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Hide parcel rates if letter sized ', 'MODULE_SHIPPING_AUSTPOST_HIDE_PARCEL', 'Yes', 'If the ordered parcel is letter sized would you like to hide the parcel postage rates', '6', '29', 'zen_cfg_select_option(array(\'No\', \'Yes\'), ', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Use cURL ', 'MODULE_SHIPPING_AUSTPOST_USE_CURL', 'No', 'Try Setting this to Yes if you get server connection errors', '6', '30', 'zen_cfg_select_option(array(\'No\', \'Yes\'), ', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Postage Delay \(days\).', 'MODULE_SHIPPING_AUSTPOST_DOFFSET', '0', 'Add this number of days to the estimated delivery times. Useful if you don\'t mail your products out on a daily basis. .', '6', '31', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Sort order of display.', 'MODULE_SHIPPING_AUSTPOST_SORT_ORDER', '0', 'Sort order of display. Lowest is displayed first.', '6', '32', now())");
$db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Tax Class', 'MODULE_SHIPPING_AUSTPOST_TAX_CLASS', '0', 'Set Tax class or -none- if not registered for GST.', '6', '33', 'zen_get_tax_class_title', 'zen_cfg_pull_down_tax_classes(', now())");

/////////////////////////  update tables //////

$conn = mysql_connect(DB_SERVER, DB_SERVER_USERNAME,DB_SERVER_PASSWORD);
$dbselect = mysql_select_db(DB_SERVER_DATABASE);
$v = mysql_query("select * from " . TABLE_PRODUCTS . " limit 1" ) ;
$inst = 1 ; $i = 0 ; $c = mysql_num_fields($v) ;
    while ($i < $c) {
    $r = mysql_field_name($v,$i) ;
	if($r == "products_length") { unset($inst) ; }  ;
    $i++ ;
    }
mysql_close($conn) ;

if(isset($inst)) {
// echo "new" ;
    $db->Execute("ALTER TABLE " .TABLE_PRODUCTS. " ADD `products_length` FLOAT(6,2) NULL AFTER `products_weight`, ADD `products_height` FLOAT(6,2) NULL AFTER `products_length`, ADD `products_width` FLOAT(6,2) NULL AFTER `products_height`" ) ;
}  else {
//echo "update" ;
    $db->Execute("ALTER TABLE " .TABLE_PRODUCTS. " CHANGE `products_length` `products_length` FLOAT(6,2), CHANGE `products_height` `products_height` FLOAT(6,2), CHANGE `products_width`  `products_width`  FLOAT(6,2)" ) ;
    }

}

function remove() {
global $db;
$db->Execute("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
}

function keys() {
    return array(
	     'MODULE_SHIPPING_AUSTPOST_STATUS',
	     'MODULE_SHIPPING_AUSTPOST_SPCODE',
	     'MODULE_SHIPPING_AUSTPOST_TYPES',
	     'MODULE_SHIPPING_AUSTPOST_RPP_HANDLING',
	     'MODULE_SHIPPING_AUSTPOST_REG_HANDLING',
	     'MODULE_SHIPPING_AUSTPOST_EXP_HANDLING',
	     'MODULE_SHIPPING_AUSTPOST_INT_HANDLING',
	     'MODULE_SHIPPING_AUSTPOST_LET_HANDLING',
	     'MODULE_SHIPPING_AUSTPOST_PPS_HANDLING',
	     'MODULE_SHIPPING_AUSTPOST_PPSE_HANDLING',
	     'MODULE_SHIPPING_AUSTPOST_ECID_HANDLING',
	     'MODULE_SHIPPING_AUSTPOST_ECIM_HANDLING',
	     'MODULE_SHIPPING_AUSTPOST_COD_HANDLING',
	     'MODULE_SHIPPING_AUSTPOST_INS_HANDLING',
	     'MODULE_SHIPPING_AUSTPOST_HIDE_HANDLING',
	     'MODULE_SHIPPING_AUSTPOST_DIMS',
	     'MODULE_SHIPPING_AUSTPOST_WEIGHT_FORMAT',
	     'MODULE_SHIPPING_AUSTPOST_HIDE_PARCEL',
	     'MODULE_SHIPPING_AUSTPOST_USE_CURL',
	     'MODULE_SHIPPING_AUSTPOST_DOFFSET',
	     'MODULE_SHIPPING_AUSTPOST_SORT_ORDER',
	     'MODULE_SHIPPING_AUSTPOST_TAX_CLASS');
    }



}  // end class


function GetAPdata($url) {

if ((MODULE_SHIPPING_AUSTPOST_USE_CURL == "Yes") &&  (function_exists('curl_init'))) {
//    echo "CURL METHOD";
//    echo '-----------------<br />';
//    echo 'URL: ' . $url . ' VARS: ' . $vars . '<br />';
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL,$url);
    curl_setopt($ch, CURLOPT_VERBOSE, 0);
    curl_setopt($ch, CURLOPT_HEADER, false);
    curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_POST, true);
      curl_setopt($ch, CURLOPT_POSTFIELDS, $vars);

    if (CURL_PROXY_REQUIRED == 'True') {
      $proxy_tunnel_flag = (defined('CURL_PROXY_TUNNEL_FLAG') && strtoupper(CURL_PROXY_TUNNEL_FLAG) == 'FALSE') ? false : true;
      curl_setopt ($ch, CURLOPT_HTTPPROXYTUNNEL, $proxy_tunnel_flag);
      curl_setopt ($ch, CURLOPT_PROXYTYPE, CURLPROXY_HTTP);
      curl_setopt ($ch, CURLOPT_PROXY, CURL_PROXY_SERVER_DETAILS);
    }
    $data = curl_exec($ch);
    $error = curl_error($ch);
    //$info=curl_getinfo($ch);
    curl_close($ch);

    if ($error != '') {
      global $messageStack;
      $messageStack->add_session('cURL communication ERROR: ' . $error, 'error');
    }
    //echo 'INFO: <pre>'; print_r($info); echo '</pre><br />' ; echo 'ERROR: ' . $error . '<br />'; print_r($data) ;
//    if ($data != '') {
	$myfile = explode("\n", $data);
    return $myfile ;
//    }

  }
   else {
  //  CURL Not exist or produced no data
//   echo "FILE METHOD";
    $myfile = file($url);
    return $myfile ;
    }
}
/////////////////////////////
function getinsurance($table) {
	$insurance_table = split("," , $table);
	$val = intval($_SESSION['cart']->show_total()/100) ;
	if ($val <= 50) {
	    $insurance[0] = $insurance_table[0] + ($val * $insurance_table[1]) ;
	    $insurance[1] = $insurance_table[2] + ($val * $insurance_table[3]) ;
	}  else {
	    if(!isset($_SESSION['emsg'])) { $_SESSION['emsg'] = 1 ;  // prg loops twice - this supresess 2nd output
	    echo "AustPost Error: Unable to Insure for this amount" ; }
		else {unset($_SESSION['emsg']) ; }
		}

return $insurance ;
}


function adjust4tax($cost, $class, $order) {
 if($class >  0)  {
 $x = $cost ;
 $cost = $cost - ($cost / (zen_get_tax_rate($class, $order->delivery['country']['id'], $order->delivery['zone_id'])+1)) ;
    if($cost == 0) {$cost = $x ;}    // couldnt get tax rate so leave alone - it is correct. We only need
				    // it for GST display and that'll fix itself when user logs in //
}
 return $cost ;
}

?>